function P = cosSinCSP(eegSignal,stimulationFrequency,numberOfHarmonics,Fs)


[numberOfTrials numberOfChannels numberOfSamples ] = size(eegSignal);%(  powtrzenie,  kana, prbki)

energyOfEEGSignal   = zeros(numberOfChannels,numberOfChannels);
energyOfNoiseSignal = zeros(numberOfChannels,numberOfChannels);

% Fs - czsto prbkowania
% numberOfSamples - dugo sygnau w prbkach
% numberOfHarmonics - liczba harmonicznych, ktre chcemy wczy do analizy
t = (0:1:numberOfSamples - 1)/Fs; 
S = zeros(numberOfSamples, 2*numberOfHarmonics);

for harmonicNumber = 1:numberOfHarmonics
    c = cos(2*pi*stimulationFrequency*harmonicNumber*t);
    s = sin(2*pi*stimulationFrequency*harmonicNumber*t);
    S(:,(harmonicNumber - 1)*2 + 1) = c/norm(c);
    S(:,(harmonicNumber - 1)*2 + 2) = s/norm(s);
end





for trialNumber = 1:numberOfTrials
    
    tmpEEGSignal      = squeeze(eegSignal(trialNumber,:,:));

    A = tmpEEGSignal*S;
    tmpSSVEP = A*S';
    tmpMatrix         = tmpSSVEP*tmpSSVEP';
    energyOfEEGSignal = energyOfEEGSignal + tmpMatrix/trace(tmpMatrix);
    
    tmpNoiseSignal = (tmpEEGSignal - tmpSSVEP);
    tmpMatrix      = tmpNoiseSignal*tmpNoiseSignal';
    energyOfNoiseSignal = energyOfNoiseSignal + tmpMatrix/trace(tmpMatrix);
    
end

energyOfEEGSignal   = energyOfEEGSignal/numberOfTrials;
energyOfNoiseSignal = energyOfNoiseSignal/numberOfTrials;


[V,D] = eig(energyOfEEGSignal,energyOfNoiseSignal);

[~, indexOfMaxEigenvalues] = sort(diag(D),1,'descend');
P = V(:,indexOfMaxEigenvalues);

end