% ustalamy nzawy plikw z danymi
nazwaPliku = 'ssvep_pattern_ania2_calibration.obci';
nameOfXMLFile = strcat(nazwaPliku,'.xml');
nameOfTagFile = strcat(nazwaPliku,'.tag'); %tagi = znaczniki zdarze
namesOfDataFiles = strcat(nazwaPliku,'.raw');

% inicjujemy obiekt rm
rm = ReadManager(nameOfXMLFile,namesOfDataFiles,nameOfTagFile);

% obieramy przydatne parametry i znaczniki
namesOfChannels   = rm.get_param('channels_names');
samplingFrequency = rm.get_param('sampling_frequency');
tagsStruct        = rm.get_tags();

numberOfChannels =8;

% tworzenie list znacznikw Target i NonTarget
numberOfStruct = length(tagsStruct);

freqs = [30,31,32,33,34,35,36,37,38,39];
freq_trial_count = zeros(length(freqs),1);
targetTimeStamps = zeros(length(freqs),8);

for structNumber = 1:numberOfStruct % iterujemy si przez tagi
    if(strcmp(tagsStruct(structNumber).name,'diodes')) % szukamy tagw o nazwie 'blink'
        frq_id = find( freqs == str2num(tagsStruct(structNumber).children.freq));
        freq_trial_count(frq_id) =freq_trial_count(frq_id)+1;
        targetTimeStamps(frq_id,freq_trial_count(frq_id)) = tagsStruct(structNumber).start_timestamp; %dodajemy timeStamp do listy targetw
    end
end

% pobieramy prbki
samples = double(rm.get_samples()); % konwersja na double jest potrzebna eby dobrze funkcjonowao filtrowanie
samples=samples(1:numberOfChannels,:); % odrzucamy kanay, ktre nie maj EEG

% montujemy dane do wsplnej redniej (common average)
M = -ones(8,8)/8;
M=M+eye(8,8)*9/8;
samples = 0.0715*M*samples;

% wycinamy dane wok znacznikw
PRE = 0.5; % czas przed tagiem w sek. (ujemny - przed tagiem, dodatni po tagu)
POST = 4.5; % czas po tagu w sek.
wycinek = floor(PRE*samplingFrequency:POST*samplingFrequency-1); % tablica ze "standardowymi' indeksami do cicia

% pobieramy targety
% tablica na sygnay target:
%                    indeksy: (czsto,  powtrzenie,  kana, prbki)
TargetSignal = zeros(length(freqs), freq_trial_count(1), numberOfChannels, length(wycinek));
for f = 1:length(freqs)
    for f_trialNumber = 1:length(targetTimeStamps(f,:))
        trigerOnset = floor(targetTimeStamps(f,f_trialNumber)*samplingFrequency);
        tenWycinek = wycinek + trigerOnset;
        if tenWycinek(1)>0 && tenWycinek(end)<=size(samples,2) % test czy wycinek ktry chcemy pobra nie wystaje poza dostpny sygna
            tmpSignal = samples(:,tenWycinek);
            tmpSignal = detrend(tmpSignal')'; % usuwanie liniowego trendu - przy krtkich wycinkach dziaa lepiej ni filtrowanie grnoprzepustowe
            TargetSignal(f,f_trialNumber, :,:) = tmpSignal;
        end
    end
end

% numberOfChannels numberOfSamples numberOfTrials
P = zeros(numberOfChannels,numberOfChannels);
numberOfHarmonics = 3;
for f = 1:length(freqs)
    tmpSignal = squeeze(TargetSignal(f,:, :,:)); % (  powtrzenie,  kana, prbki)
    S = zeros(size(tmpSignal));
    %  tmpSignal = permute(tmpSignal,[2,3,1]);   % numberOfChannels numberOfSamples numberOfTrials
    P(:,:) = cosSinCSP(tmpSignal,freqs(f),numberOfHarmonics,samplingFrequency);
    for i = 1:freq_trial_count
        S(i,:,:) = P'*squeeze(    tmpSignal(i,:,:));
    end
    figure('Name',['Stymulacja: ',num2str(freqs(f)),' Hz'])
    for i =1:numberOfChannels
        subplot(2,8,i)
        PP=0;
        for rep = 1:freq_trial_count
            x = tmpSignal(rep,i,:);           
            [Pxx,ff]=pwelch(x, 512,1,512,512);
            PP =PP + Pxx;
        end
        plot(ff(ff<60),PP(ff<60))
        title(namesOfChannels{i})
        subplot(2,8,8+i)
        PP=0;
        for rep = 1:freq_trial_count
            s = S(rep,i,:);            
            [Pss,ff]=pwelch(s, 512,1,512,512);
            PP =PP + Pss;
        end
        plot(ff(ff<60),PP(ff<60))

         title(['Kana: ', num2str(i)])
    end
    
    
end


%pwelch(squeeze(P(1,1,:))'*squeeze(TargetSignal(1,1,:,:)),512,511,512,512);

% dla ilustracji podgldamy rednie po powtrzeniach ze wszystkich target?
% i non-targetw
% plot(squeeze(mean(TargetSignal,1))','r');

